///////////////////////////////////////////////////////////
//		ISO_SYSTEMS.WDL          
//
//    Copyright 2004 Sean Patrick Hannifin
//		Created for 3DGS Isometric Tutorial
//		Version 1.00  -  August 2004
//
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
// Global variables

entity* MainObject;	// Main object of the camera, used in
							// the camera_control() functions.
							
var CamZoom = 300;	// The height of the camera above the
							// main object
var CamAngle = 0;		// The angle the camera is viewing the
							// object

// These variables are used in the Camera_Control functions
var ZoomSpeed = 2;
var RotateSpeed = 0.3;
var MoveSpeed = 2.5;
// Zoom Limits
var ZoomDownLimit = 200;
var ZoomUpLimit = 1400;
// Map Limits
var XMax = 3000;
var XMin = -3000;
var YMax = 3000;
var YMin = -3000;

///////////////////////////////////////////////////////////
// The camera

// This action is to be assigned to the main object of the
// camera
action CameraPoint
{
	// Set the entity equal to the MainObject entity pointer
	MainObject = me;
	
	// Make me invisible and passable
	my.invisible = on;
	my.passable = on;
}

// This function initializes the camera
function Camera_Init()
{
	// We have to wait for the level to load, so the engine
	// doesn't think that the point MainObject is empty
	wait(10);
	
	Camera_Control();
	Camera_Control2();
	
	// Keep updating the camera's position
	while(1)
	{	
		// Set the camera's position in space based on
		// the position of MainObject;
		camera.z = CamZoom;
		camera.x = MainObject.x + CamZoom * cos(CamAngle);
		camera.y = MainObject.y + CamZoom * sin(CamAngle);
		
		// Turn the camera towards the MainObject
		vec_set(temp,MainObject.x);
		vec_sub(temp,camera.x);
		vec_to_angle(camera.pan,temp);
		
		// Reset CamAngle if it is at 360 or above
		if (CamAngle > 359)
		{
			CamAngle = 0;		
		}
		wait(1);
	}
}

// This function is called from the Camera_Control functions
// It tests to make sure that MainObject does not go
// 'out of bounds'
function TestLimits()
{
	MainObject.x = max(min(MainObject.x, XMax), XMin);
	MainObject.y = max(min(MainObject.y, Ymax), YMin);
}

// These functions control the movement of the camera and
// of MainObject
function Camera_Control()
{
	while (1)
	{
		while ((key_cuu == 1) && (key_ctrl == 1) && (key_cud != 1))
		{
			CamZoom -= ZoomSpeed;
			if (CamZoom < ZoomDownLimit)
			{
				CamZoom = ZoomDownLimit;
			}
			wait(1);
		}
		while ((key_cud == 1) && (key_ctrl == 1) && (key_cuu != 1))
		{
			CamZoom += ZoomSpeed;
			if (CamZoom > ZoomUpLimit)
			{
				CamZoom = ZoomUpLimit;
			}
			wait(1);
		}
		while ((key_cuu == 1) && (key_ctrl != 1) && (key_cud != 1))
		{
			MainObject.y += sin(camera.pan) * MoveSpeed;
			MainObject.x += cos(camera.pan) * MoveSpeed;
			TestLimits();
			wait(1);
		}
		while ((key_cud == 1) && (key_ctrl != 1) && (key_cuu != 1))
		{
			MainObject.y -= sin(camera.pan) * MoveSpeed;
			MainObject.x -= cos(camera.pan) * MoveSpeed;
			TestLimits();
			wait(1);
		}
		wait(1);
	}
}

function Camera_Control2()
{
	while(1)
	{
		while((key_cul == 1) && (key_ctrl == 1) && (key_cur != 1))
		{
			CamAngle -= RotateSpeed;
			wait(1);
		}
		while((key_cur ==1) && (key_ctrl == 1) && (key_cul != 1))
		{
			CamAngle += RotateSpeed;
			wait(1);
		}
		while((key_cur == 1) && (key_ctrl != 1) && (key_cul != 1))
		{
			MainObject.y -= cos(camera.pan) * MoveSpeed;
			MainObject.x += sin(camera.pan) * MoveSpeed;
			TestLimits();
			wait(1);
		}
		while((key_cul == 1) && (key_ctrl != 1) && (key_cur != 1))
		{
			MainObject.y += cos(camera.pan) * MoveSpeed;
			MainObject.x -= sin(camera.pan) * MoveSpeed;
			TestLimits();
			wait(1);
		}
		wait(1);
	}
}